﻿#include <platform.h>
#include <gpio.h>


void gpio_set(Pin pin, int value) {
	FGPIO_Type* p = GET_FPT(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);
	
	p->PDOR = (p->PDIR & ~(1u << pin_index)) | (((unsigned int)!!value) << pin_index);
}

int gpio_get(Pin pin) {
	FGPIO_Type* p = GET_FPT(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);
	return (p->PDIR >> pin_index) & 0x1;
}



void gpio_set_mode(Pin pin, PinMode mode) {
	FGPIO_Type* p = GET_FPT(pin);
	uint32_t port_index = GET_PORT_INDEX(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);
	PORT_Type* p2 = GET_PORT(pin);
	uint32_t reg;
	
	// Enable the clock to the port.
	SIM->SCGC5 |= 1u << (SIM_SCGC5_PORTA_SHIFT + port_index);
	
	reg = p2->PCR[pin_index] & ~(0x7u << 8);
	
	switch(mode) {
		case Reset:
			break;
		case Input:
			p->PDDR &= ~(1 << pin_index); // Set as input.
			reg |= 0x1 << 8; // Pin mux GPIO.
			break;
		case Output:
			reg |= 0x1u << 8; // Pin mux GPIO.
			p->PDDR |= (1 << pin_index); // Set as output.
			break;
		case PullUp:
			p->PDDR |= 1 << pin_index; // Set as input.
			reg |= (0x1 << 8) | // Pin mux GPIO.
			       (0x1 << 1) | // Pin pull enable.
			       (0x1 << 0);  // Enable pullup resistor.
			gpio_set(pin, 1);
			break;
		case PullDown:
			p->PDDR |= 1 << pin_index; // Set as input.
			reg |= (0x1 << 8) | // Pin mux GPIO.
			       (0x1 << 1) | // Pin pull enable.
			       (0x0 << 0);  // Enable pulldown resistor.
			gpio_set(pin, 0);
			break;
	}
	
	p2->PCR[pin_index] = reg;
}


// *******************************ARM University Program Copyright © ARM Ltd 2014*************************************   
